/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires;

import com.google.gson.JsonElement;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import dev.lopyluna.dndesires.DnDesires;
import dev.lopyluna.dndesires.content.datagen.DatagenTags;
import dev.lopyluna.dndesires.content.datagen.DesiresRecipeProvider;
import dev.lopyluna.dndesires.content.datagen.recipes.MechanicalCraftingGen;
import dev.lopyluna.dndesires.register.DesiresSoundEvents;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DesiresDatagen {
    public static void gatherDataHighPriority(GatherDataEvent event) {
        if (event.getMods().contains("dndesires")) {
            DesiresDatagen.addExtraRegistrateData();
        }
    }

    public static void gatherData(GatherDataEvent event) {
        if (!event.getMods().contains("dndesires")) {
            return;
        }
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)DesiresSoundEvents.provider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new MechanicalCraftingGen(output, lookupProvider));
        if (event.includeServer()) {
            DesiresRecipeProvider.registerAllProcessing(generator, output, lookupProvider);
        }
    }

    private static void addExtraRegistrateData() {
        DatagenTags.addGenerators();
        DnDesires.REG.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            DesiresSoundEvents.provideLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/dndesires/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        for (Map.Entry entry : jsonElement.getAsJsonObject().entrySet()) {
            consumer.accept((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }
}

